package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.ShardId
import scala.jdk.CollectionConverters.*
final case class Shard(
    shardId: ShardId,
    parentShardId: Option[ShardId] = None,
    adjacentParentShardId: Option[ShardId] = None,
    hashKeyRange: zio.aws.kinesis.model.HashKeyRange,
    sequenceNumberRange: zio.aws.kinesis.model.SequenceNumberRange
) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesis.model.Shard = {
    import Shard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.Shard
      .builder()
      .shardId(ShardId.unwrap(shardId): java.lang.String)
      .optionallyWith(
        parentShardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.parentShardId)
      .optionallyWith(
        adjacentParentShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.adjacentParentShardId)
      .hashKeyRange(hashKeyRange.buildAwsValue())
      .sequenceNumberRange(sequenceNumberRange.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.Shard.ReadOnly =
    zio.aws.kinesis.model.Shard.wrap(buildAwsValue())
}
object Shard {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kinesis.model.Shard] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.Shard = zio.aws.kinesis.model.Shard(
      shardId,
      parentShardId.map(value => value),
      adjacentParentShardId.map(value => value),
      hashKeyRange.asEditable,
      sequenceNumberRange.asEditable
    )
    def shardId: ShardId
    def parentShardId: Option[ShardId]
    def adjacentParentShardId: Option[ShardId]
    def hashKeyRange: zio.aws.kinesis.model.HashKeyRange.ReadOnly
    def sequenceNumberRange: zio.aws.kinesis.model.SequenceNumberRange.ReadOnly
    def getShardId: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardId)
    def getParentShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("parentShardId", parentShardId)
    def getAdjacentParentShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("adjacentParentShardId", adjacentParentShardId)
    def getHashKeyRange
        : ZIO[Any, Nothing, zio.aws.kinesis.model.HashKeyRange.ReadOnly] =
      ZIO.succeed(hashKeyRange)
    def getSequenceNumberRange: ZIO[
      Any,
      Nothing,
      zio.aws.kinesis.model.SequenceNumberRange.ReadOnly
    ] = ZIO.succeed(sequenceNumberRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.Shard
  ) extends zio.aws.kinesis.model.Shard.ReadOnly {
    override val shardId: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardId())
    override val parentShardId: Option[ShardId] = scala
      .Option(impl.parentShardId())
      .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val adjacentParentShardId: Option[ShardId] = scala
      .Option(impl.adjacentParentShardId())
      .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val hashKeyRange: zio.aws.kinesis.model.HashKeyRange.ReadOnly =
      zio.aws.kinesis.model.HashKeyRange.wrap(impl.hashKeyRange())
    override val sequenceNumberRange
        : zio.aws.kinesis.model.SequenceNumberRange.ReadOnly =
      zio.aws.kinesis.model.SequenceNumberRange.wrap(impl.sequenceNumberRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.Shard
  ): zio.aws.kinesis.model.Shard.ReadOnly = new Wrapper(impl)
}
