package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListStreamConsumersResponse(
    consumers: Option[Iterable[zio.aws.kinesis.model.Consumer]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse = {
    import ListStreamConsumersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
      .builder()
      .optionallyWith(
        consumers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly =
    zio.aws.kinesis.model.ListStreamConsumersResponse.wrap(buildAwsValue())
}
object ListStreamConsumersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListStreamConsumersResponse =
      zio.aws.kinesis.model.ListStreamConsumersResponse(
        consumers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def consumers: Option[List[zio.aws.kinesis.model.Consumer.ReadOnly]]
    def nextToken: Option[NextToken]
    def getConsumers
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.Consumer.ReadOnly]] =
      AwsError.unwrapOptionField("consumers", consumers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
  ) extends zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly {
    override val consumers
        : Option[List[zio.aws.kinesis.model.Consumer.ReadOnly]] = scala
      .Option(impl.consumers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesis.model.Consumer.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
  ): zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly = new Wrapper(
    impl
  )
}
