package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.{ConsumerARN, ConsumerName, StreamARN}
import scala.jdk.CollectionConverters.*
final case class DescribeStreamConsumerRequest(
    streamARN: Option[StreamARN] = None,
    consumerName: Option[ConsumerName] = None,
    consumerARN: Option[ConsumerARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest = {
    import DescribeStreamConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest
      .builder()
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .optionallyWith(
        consumerName.map(value => ConsumerName.unwrap(value): java.lang.String)
      )(_.consumerName)
      .optionallyWith(
        consumerARN.map(value => ConsumerARN.unwrap(value): java.lang.String)
      )(_.consumerARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeStreamConsumerRequest.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamConsumerRequest.wrap(buildAwsValue())
}
object DescribeStreamConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamConsumerRequest =
      zio.aws.kinesis.model.DescribeStreamConsumerRequest(
        streamARN.map(value => value),
        consumerName.map(value => value),
        consumerARN.map(value => value)
      )
    def streamARN: Option[StreamARN]
    def consumerName: Option[ConsumerName]
    def consumerARN: Option[ConsumerARN]
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getConsumerName: ZIO[Any, AwsError, ConsumerName] =
      AwsError.unwrapOptionField("consumerName", consumerName)
    def getConsumerARN: ZIO[Any, AwsError, ConsumerARN] =
      AwsError.unwrapOptionField("consumerARN", consumerARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest
  ) extends zio.aws.kinesis.model.DescribeStreamConsumerRequest.ReadOnly {
    override val streamARN: Option[StreamARN] = scala
      .Option(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
    override val consumerName: Option[ConsumerName] = scala
      .Option(impl.consumerName())
      .map(value => zio.aws.kinesis.model.primitives.ConsumerName(value))
    override val consumerARN: Option[ConsumerARN] = scala
      .Option(impl.consumerARN())
      .map(value => zio.aws.kinesis.model.primitives.ConsumerARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest
  ): zio.aws.kinesis.model.DescribeStreamConsumerRequest.ReadOnly = new Wrapper(
    impl
  )
}
