package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.{BooleanObject, StreamName}
import scala.jdk.CollectionConverters.*
final case class DeleteStreamRequest(
    streamName: StreamName,
    enforceConsumerDeletion: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest = {
    import DeleteStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .optionallyWith(
        enforceConsumerDeletion.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.enforceConsumerDeletion)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DeleteStreamRequest.ReadOnly =
    zio.aws.kinesis.model.DeleteStreamRequest.wrap(buildAwsValue())
}
object DeleteStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DeleteStreamRequest =
      zio.aws.kinesis.model.DeleteStreamRequest(
        streamName,
        enforceConsumerDeletion.map(value => value)
      )
    def streamName: StreamName
    def enforceConsumerDeletion: Option[BooleanObject]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getEnforceConsumerDeletion: ZIO[Any, AwsError, BooleanObject] = AwsError
      .unwrapOptionField("enforceConsumerDeletion", enforceConsumerDeletion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
  ) extends zio.aws.kinesis.model.DeleteStreamRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val enforceConsumerDeletion: Option[BooleanObject] = scala
      .Option(impl.enforceConsumerDeletion())
      .map(value => zio.aws.kinesis.model.primitives.BooleanObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest
  ): zio.aws.kinesis.model.DeleteStreamRequest.ReadOnly = new Wrapper(impl)
}
