package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.ShardId
import scala.jdk.CollectionConverters.*
final case class ChildShard(
    shardId: ShardId,
    parentShards: Iterable[ShardId],
    hashKeyRange: zio.aws.kinesis.model.HashKeyRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ChildShard = {
    import ChildShard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ChildShard
      .builder()
      .shardId(ShardId.unwrap(shardId): java.lang.String)
      .parentShards(parentShards.map { item =>
        ShardId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .hashKeyRange(hashKeyRange.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ChildShard.ReadOnly =
    zio.aws.kinesis.model.ChildShard.wrap(buildAwsValue())
}
object ChildShard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ChildShard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ChildShard = zio.aws.kinesis.model
      .ChildShard(shardId, parentShards, hashKeyRange.asEditable)
    def shardId: ShardId
    def parentShards: List[ShardId]
    def hashKeyRange: zio.aws.kinesis.model.HashKeyRange.ReadOnly
    def getShardId: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardId)
    def getParentShards: ZIO[Any, Nothing, List[ShardId]] =
      ZIO.succeed(parentShards)
    def getHashKeyRange
        : ZIO[Any, Nothing, zio.aws.kinesis.model.HashKeyRange.ReadOnly] =
      ZIO.succeed(hashKeyRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ChildShard
  ) extends zio.aws.kinesis.model.ChildShard.ReadOnly {
    override val shardId: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardId())
    override val parentShards: List[ShardId] = impl
      .parentShards()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.primitives.ShardId(item)
      }
      .toList
    override val hashKeyRange: zio.aws.kinesis.model.HashKeyRange.ReadOnly =
      zio.aws.kinesis.model.HashKeyRange.wrap(impl.hashKeyRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ChildShard
  ): zio.aws.kinesis.model.ChildShard.ReadOnly = new Wrapper(impl)
}
