package zio.aws.kinesis
import zio.aws.kinesis.model.primitives.ShardIterator.Type
import zio.aws.kinesis.model.primitives.{TagValue, TagKey, StreamName, ShardId}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object BooleanObject extends Subtype[Boolean]
    type BooleanObject = zio.aws.kinesis.model.primitives.BooleanObject.Type
    object ConsumerARN extends Subtype[String]
    type ConsumerARN = zio.aws.kinesis.model.primitives.ConsumerARN.Type
    object ConsumerCountObject extends Subtype[Int]
    type ConsumerCountObject =
      zio.aws.kinesis.model.primitives.ConsumerCountObject.Type
    object ConsumerName extends Subtype[String]
    type ConsumerName = zio.aws.kinesis.model.primitives.ConsumerName.Type
    object Data extends Subtype[Chunk[Byte]]
    type Data = zio.aws.kinesis.model.primitives.Data.Type
    object DescribeStreamInputLimit extends Subtype[Int]
    type DescribeStreamInputLimit =
      zio.aws.kinesis.model.primitives.DescribeStreamInputLimit.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.kinesis.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.kinesis.model.primitives.ErrorMessage.Type
    object GetRecordsInputLimit extends Subtype[Int]
    type GetRecordsInputLimit =
      zio.aws.kinesis.model.primitives.GetRecordsInputLimit.Type
    object HashKey extends Subtype[String]
    type HashKey = zio.aws.kinesis.model.primitives.HashKey.Type
    object KeyId extends Subtype[String]
    type KeyId = zio.aws.kinesis.model.primitives.KeyId.Type
    object ListShardsInputLimit extends Subtype[Int]
    type ListShardsInputLimit =
      zio.aws.kinesis.model.primitives.ListShardsInputLimit.Type
    object ListStreamConsumersInputLimit extends Subtype[Int]
    type ListStreamConsumersInputLimit =
      zio.aws.kinesis.model.primitives.ListStreamConsumersInputLimit.Type
    object ListStreamsInputLimit extends Subtype[Int]
    type ListStreamsInputLimit =
      zio.aws.kinesis.model.primitives.ListStreamsInputLimit.Type
    object ListTagsForStreamInputLimit extends Subtype[Int]
    type ListTagsForStreamInputLimit =
      zio.aws.kinesis.model.primitives.ListTagsForStreamInputLimit.Type
    object MillisBehindLatest extends Subtype[Long]
    type MillisBehindLatest =
      zio.aws.kinesis.model.primitives.MillisBehindLatest.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.kinesis.model.primitives.NextToken.Type
    object OnDemandStreamCountLimitObject extends Subtype[Int]
    type OnDemandStreamCountLimitObject =
      zio.aws.kinesis.model.primitives.OnDemandStreamCountLimitObject.Type
    object OnDemandStreamCountObject extends Subtype[Int]
    type OnDemandStreamCountObject =
      zio.aws.kinesis.model.primitives.OnDemandStreamCountObject.Type
    object PartitionKey extends Subtype[String]
    type PartitionKey = zio.aws.kinesis.model.primitives.PartitionKey.Type
    object PositiveIntegerObject extends Subtype[Int]
    type PositiveIntegerObject =
      zio.aws.kinesis.model.primitives.PositiveIntegerObject.Type
    object RetentionPeriodHours extends Subtype[Int]
    type RetentionPeriodHours =
      zio.aws.kinesis.model.primitives.RetentionPeriodHours.Type
    object SequenceNumber extends Subtype[String]
    type SequenceNumber = zio.aws.kinesis.model.primitives.SequenceNumber.Type
    object ShardCountObject extends Subtype[Int]
    type ShardCountObject =
      zio.aws.kinesis.model.primitives.ShardCountObject.Type
    object ShardId extends Subtype[String]
    type ShardId = zio.aws.kinesis.model.primitives.ShardId.Type
    object ShardIterator extends Subtype[String]
    type ShardIterator = zio.aws.kinesis.model.primitives.ShardIterator.Type
    object StreamARN extends Subtype[String]
    type StreamARN = zio.aws.kinesis.model.primitives.StreamARN.Type
    object StreamName extends Subtype[String]
    type StreamName = zio.aws.kinesis.model.primitives.StreamName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.kinesis.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.kinesis.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.kinesis.model.primitives.Timestamp.Type
  }
  type ChildShardList = List[zio.aws.kinesis.model.ChildShard]
  type ConsumerList = List[zio.aws.kinesis.model.Consumer]
  type EnhancedMonitoringList = List[zio.aws.kinesis.model.EnhancedMetrics]
  type MetricsNameList = List[zio.aws.kinesis.model.MetricsName]
  type PutRecordsRequestEntryList =
    List[zio.aws.kinesis.model.PutRecordsRequestEntry]
  type PutRecordsResultEntryList =
    List[zio.aws.kinesis.model.PutRecordsResultEntry]
  type RecordList = List[zio.aws.kinesis.model.Record]
  type ShardIdList = List[ShardId]
  type ShardList = List[zio.aws.kinesis.model.Shard]
  type StreamNameList = List[StreamName]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.kinesis.model.Tag]
  type TagMap = Map[TagKey, TagValue]
}
