package zio.aws.kinesis.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.{PositiveIntegerObject, StreamName}
import scala.jdk.CollectionConverters.*
final case class UpdateShardCountResponse(
    streamName: Option[StreamName] = None,
    currentShardCount: Option[PositiveIntegerObject] = None,
    targetShardCount: Option[PositiveIntegerObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse = {
    import UpdateShardCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        currentShardCount.map(value =>
          PositiveIntegerObject.unwrap(value): Integer
        )
      )(_.currentShardCount)
      .optionallyWith(
        targetShardCount.map(value =>
          PositiveIntegerObject.unwrap(value): Integer
        )
      )(_.targetShardCount)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly =
    zio.aws.kinesis.model.UpdateShardCountResponse.wrap(buildAwsValue())
}
object UpdateShardCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.UpdateShardCountResponse =
      zio.aws.kinesis.model.UpdateShardCountResponse(
        streamName.map(value => value),
        currentShardCount.map(value => value),
        targetShardCount.map(value => value)
      )
    def streamName: Option[StreamName]
    def currentShardCount: Option[PositiveIntegerObject]
    def targetShardCount: Option[PositiveIntegerObject]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getCurrentShardCount: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("currentShardCount", currentShardCount)
    def getTargetShardCount: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("targetShardCount", targetShardCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
  ) extends zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly {
    override val streamName: Option[StreamName] = scala
      .Option(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val currentShardCount: Option[PositiveIntegerObject] = scala
      .Option(impl.currentShardCount())
      .map(value =>
        zio.aws.kinesis.model.primitives.PositiveIntegerObject(value)
      )
    override val targetShardCount: Option[PositiveIntegerObject] = scala
      .Option(impl.targetShardCount())
      .map(value =>
        zio.aws.kinesis.model.primitives.PositiveIntegerObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
  ): zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly = new Wrapper(impl)
}
