package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{KeyId, StreamName}
import scala.jdk.CollectionConverters.*
final case class StartStreamEncryptionRequest(
    streamName: StreamName,
    encryptionType: zio.aws.kinesis.model.EncryptionType,
    keyId: KeyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest = {
    import StartStreamEncryptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .encryptionType(encryptionType.unwrap)
      .keyId(KeyId.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.StartStreamEncryptionRequest.ReadOnly =
    zio.aws.kinesis.model.StartStreamEncryptionRequest.wrap(buildAwsValue())
}
object StartStreamEncryptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.StartStreamEncryptionRequest =
      zio.aws.kinesis.model
        .StartStreamEncryptionRequest(streamName, encryptionType, keyId)
    def streamName: StreamName
    def encryptionType: zio.aws.kinesis.model.EncryptionType
    def keyId: KeyId
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.kinesis.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getKeyId: ZIO[Any, Nothing, KeyId] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
  ) extends zio.aws.kinesis.model.StartStreamEncryptionRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val encryptionType: zio.aws.kinesis.model.EncryptionType =
      zio.aws.kinesis.model.EncryptionType.wrap(impl.encryptionType())
    override val keyId: KeyId =
      zio.aws.kinesis.model.primitives.KeyId(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
  ): zio.aws.kinesis.model.StartStreamEncryptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
