package zio.aws.kinesis.model
import scala.jdk.CollectionConverters.*
sealed trait ShardFilterType {
  def unwrap: software.amazon.awssdk.services.kinesis.model.ShardFilterType
}
object ShardFilterType {
  def wrap(
      value: software.amazon.awssdk.services.kinesis.model.ShardFilterType
  ): zio.aws.kinesis.model.ShardFilterType = value match {
    case software.amazon.awssdk.services.kinesis.model.ShardFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesis.model.ShardFilterType.AFTER_SHARD_ID =>
      val r = AFTER_SHARD_ID
      r
    case software.amazon.awssdk.services.kinesis.model.ShardFilterType.AT_TRIM_HORIZON =>
      val r = AT_TRIM_HORIZON
      r
    case software.amazon.awssdk.services.kinesis.model.ShardFilterType.FROM_TRIM_HORIZON =>
      val r = FROM_TRIM_HORIZON
      r
    case software.amazon.awssdk.services.kinesis.model.ShardFilterType.AT_LATEST =>
      val r = AT_LATEST
      r
    case software.amazon.awssdk.services.kinesis.model.ShardFilterType.AT_TIMESTAMP =>
      val r = AT_TIMESTAMP
      r
    case software.amazon.awssdk.services.kinesis.model.ShardFilterType.FROM_TIMESTAMP =>
      val r = FROM_TIMESTAMP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesis.model.ShardFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardFilterType =
      software.amazon.awssdk.services.kinesis.model.ShardFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object AFTER_SHARD_ID extends zio.aws.kinesis.model.ShardFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardFilterType =
      software.amazon.awssdk.services.kinesis.model.ShardFilterType.AFTER_SHARD_ID
  }
  case object AT_TRIM_HORIZON extends zio.aws.kinesis.model.ShardFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardFilterType =
      software.amazon.awssdk.services.kinesis.model.ShardFilterType.AT_TRIM_HORIZON
  }
  case object FROM_TRIM_HORIZON extends zio.aws.kinesis.model.ShardFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardFilterType =
      software.amazon.awssdk.services.kinesis.model.ShardFilterType.FROM_TRIM_HORIZON
  }
  case object AT_LATEST extends zio.aws.kinesis.model.ShardFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardFilterType =
      software.amazon.awssdk.services.kinesis.model.ShardFilterType.AT_LATEST
  }
  case object AT_TIMESTAMP extends zio.aws.kinesis.model.ShardFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardFilterType =
      software.amazon.awssdk.services.kinesis.model.ShardFilterType.AT_TIMESTAMP
  }
  case object FROM_TIMESTAMP extends zio.aws.kinesis.model.ShardFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardFilterType =
      software.amazon.awssdk.services.kinesis.model.ShardFilterType.FROM_TIMESTAMP
  }
}
