package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterStreamConsumerResponse(
    consumer: zio.aws.kinesis.model.Consumer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse = {
    import RegisterStreamConsumerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse
      .builder()
      .consumer(consumer.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly =
    zio.aws.kinesis.model.RegisterStreamConsumerResponse.wrap(buildAwsValue())
}
object RegisterStreamConsumerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.RegisterStreamConsumerResponse =
      zio.aws.kinesis.model.RegisterStreamConsumerResponse(consumer.asEditable)
    def consumer: zio.aws.kinesis.model.Consumer.ReadOnly
    def getConsumer
        : ZIO[Any, Nothing, zio.aws.kinesis.model.Consumer.ReadOnly] =
      ZIO.succeed(consumer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse
  ) extends zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly {
    override val consumer: zio.aws.kinesis.model.Consumer.ReadOnly =
      zio.aws.kinesis.model.Consumer.wrap(impl.consumer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse
  ): zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly =
    new Wrapper(impl)
}
