package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{BooleanObject, StreamName}
import scala.jdk.CollectionConverters.*
final case class ListStreamsResponse(
    streamNames: Iterable[StreamName],
    hasMoreStreams: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListStreamsResponse = {
    import ListStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
      .builder()
      .streamNames(streamNames.map { item =>
        StreamName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .hasMoreStreams(BooleanObject.unwrap(hasMoreStreams): java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListStreamsResponse.ReadOnly =
    zio.aws.kinesis.model.ListStreamsResponse.wrap(buildAwsValue())
}
object ListStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListStreamsResponse =
      zio.aws.kinesis.model.ListStreamsResponse(streamNames, hasMoreStreams)
    def streamNames: List[StreamName]
    def hasMoreStreams: BooleanObject
    def getStreamNames: ZIO[Any, Nothing, List[StreamName]] =
      ZIO.succeed(streamNames)
    def getHasMoreStreams: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
  ) extends zio.aws.kinesis.model.ListStreamsResponse.ReadOnly {
    override val streamNames: List[StreamName] = impl
      .streamNames()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.primitives.StreamName(item)
      }
      .toList
    override val hasMoreStreams: BooleanObject =
      zio.aws.kinesis.model.primitives.BooleanObject(impl.hasMoreStreams())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
  ): zio.aws.kinesis.model.ListStreamsResponse.ReadOnly = new Wrapper(impl)
}
