package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.KeyspaceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetKeyspaceRequest(keyspaceName: KeyspaceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest = {
    import GetKeyspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.GetKeyspaceRequest.ReadOnly =
    zio.aws.keyspaces.model.GetKeyspaceRequest.wrap(buildAwsValue())
}
object GetKeyspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.GetKeyspaceRequest =
      zio.aws.keyspaces.model.GetKeyspaceRequest(keyspaceName)
    def keyspaceName: KeyspaceName
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest
  ) extends zio.aws.keyspaces.model.GetKeyspaceRequest.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest
  ): zio.aws.keyspaces.model.GetKeyspaceRequest.ReadOnly = new Wrapper(impl)
}
