package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.Region
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicationSpecification(
    replicationStrategy: zio.aws.keyspaces.model.Rs,
    regionList: Optional[Iterable[Region]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ReplicationSpecification = {
    import ReplicationSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ReplicationSpecification
      .builder()
      .replicationStrategy(replicationStrategy.unwrap)
      .optionallyWith(
        regionList.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regionList)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ReplicationSpecification.ReadOnly =
    zio.aws.keyspaces.model.ReplicationSpecification.wrap(buildAwsValue())
}
object ReplicationSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ReplicationSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ReplicationSpecification =
      zio.aws.keyspaces.model.ReplicationSpecification(
        replicationStrategy,
        regionList.map(value => value)
      )
    def replicationStrategy: zio.aws.keyspaces.model.Rs
    def regionList: Optional[List[Region]]
    def getReplicationStrategy: ZIO[Any, Nothing, zio.aws.keyspaces.model.Rs] =
      ZIO.succeed(replicationStrategy)
    def getRegionList: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regionList", regionList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicationSpecification
  ) extends zio.aws.keyspaces.model.ReplicationSpecification.ReadOnly {
    override val replicationStrategy: zio.aws.keyspaces.model.Rs =
      zio.aws.keyspaces.model.Rs.wrap(impl.replicationStrategy())
    override val regionList: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regionList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.keyspaces.model.primitives.Region(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicationSpecification
  ): zio.aws.keyspaces.model.ReplicationSpecification.ReadOnly = new Wrapper(
    impl
  )
}
