package zio.aws.keyspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.keyspaces.model.primitives.{
  DefaultTimeToLive,
  TableName,
  KeyspaceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateTableRequest(
    keyspaceName: KeyspaceName,
    tableName: TableName,
    addColumns: Optional[Iterable[zio.aws.keyspaces.model.ColumnDefinition]] =
      Optional.Absent,
    capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecification
    ] = Optional.Absent,
    encryptionSpecification: Optional[
      zio.aws.keyspaces.model.EncryptionSpecification
    ] = Optional.Absent,
    pointInTimeRecovery: Optional[zio.aws.keyspaces.model.PointInTimeRecovery] =
      Optional.Absent,
    ttl: Optional[zio.aws.keyspaces.model.TimeToLive] = Optional.Absent,
    defaultTimeToLive: Optional[DefaultTimeToLive] = Optional.Absent,
    clientSideTimestamps: Optional[
      zio.aws.keyspaces.model.ClientSideTimestamps
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest = {
    import UpdateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        addColumns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addColumns)
      .optionallyWith(
        capacitySpecification.map(value => value.buildAwsValue())
      )(_.capacitySpecification)
      .optionallyWith(
        encryptionSpecification.map(value => value.buildAwsValue())
      )(_.encryptionSpecification)
      .optionallyWith(pointInTimeRecovery.map(value => value.buildAwsValue()))(
        _.pointInTimeRecovery
      )
      .optionallyWith(ttl.map(value => value.buildAwsValue()))(_.ttl)
      .optionallyWith(
        defaultTimeToLive.map(value => DefaultTimeToLive.unwrap(value): Integer)
      )(_.defaultTimeToLive)
      .optionallyWith(clientSideTimestamps.map(value => value.buildAwsValue()))(
        _.clientSideTimestamps
      )
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.UpdateTableRequest.ReadOnly =
    zio.aws.keyspaces.model.UpdateTableRequest.wrap(buildAwsValue())
}
object UpdateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.UpdateTableRequest =
      zio.aws.keyspaces.model.UpdateTableRequest(
        keyspaceName,
        tableName,
        addColumns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capacitySpecification.map(value => value.asEditable),
        encryptionSpecification.map(value => value.asEditable),
        pointInTimeRecovery.map(value => value.asEditable),
        ttl.map(value => value.asEditable),
        defaultTimeToLive.map(value => value),
        clientSideTimestamps.map(value => value.asEditable)
      )
    def keyspaceName: KeyspaceName
    def tableName: TableName
    def addColumns
        : Optional[List[zio.aws.keyspaces.model.ColumnDefinition.ReadOnly]]
    def capacitySpecification
        : Optional[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly]
    def encryptionSpecification
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly]
    def pointInTimeRecovery
        : Optional[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly]
    def ttl: Optional[zio.aws.keyspaces.model.TimeToLive.ReadOnly]
    def defaultTimeToLive: Optional[DefaultTimeToLive]
    def clientSideTimestamps
        : Optional[zio.aws.keyspaces.model.ClientSideTimestamps.ReadOnly]
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getAddColumns: ZIO[Any, AwsError, List[
      zio.aws.keyspaces.model.ColumnDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("addColumns", addColumns)
    def getCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.CapacitySpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("capacitySpecification", capacitySpecification)
    def getEncryptionSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionSpecification",
      encryptionSpecification
    )
    def getPointInTimeRecovery: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly
    ] = AwsError.unwrapOptionField("pointInTimeRecovery", pointInTimeRecovery)
    def getTtl
        : ZIO[Any, AwsError, zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getDefaultTimeToLive: ZIO[Any, AwsError, DefaultTimeToLive] =
      AwsError.unwrapOptionField("defaultTimeToLive", defaultTimeToLive)
    def getClientSideTimestamps: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.ClientSideTimestamps.ReadOnly
    ] = AwsError.unwrapOptionField("clientSideTimestamps", clientSideTimestamps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
  ) extends zio.aws.keyspaces.model.UpdateTableRequest.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.tableName())
    override val addColumns
        : Optional[List[zio.aws.keyspaces.model.ColumnDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.ColumnDefinition.wrap(item)
          }.toList
        )
    override val capacitySpecification
        : Optional[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacitySpecification())
        .map(value => zio.aws.keyspaces.model.CapacitySpecification.wrap(value))
    override val encryptionSpecification
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionSpecification())
        .map(value =>
          zio.aws.keyspaces.model.EncryptionSpecification.wrap(value)
        )
    override val pointInTimeRecovery
        : Optional[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pointInTimeRecovery())
        .map(value => zio.aws.keyspaces.model.PointInTimeRecovery.wrap(value))
    override val ttl: Optional[zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ttl())
        .map(value => zio.aws.keyspaces.model.TimeToLive.wrap(value))
    override val defaultTimeToLive: Optional[DefaultTimeToLive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultTimeToLive())
        .map(value =>
          zio.aws.keyspaces.model.primitives.DefaultTimeToLive(value)
        )
    override val clientSideTimestamps
        : Optional[zio.aws.keyspaces.model.ClientSideTimestamps.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSideTimestamps())
        .map(value => zio.aws.keyspaces.model.ClientSideTimestamps.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
  ): zio.aws.keyspaces.model.UpdateTableRequest.ReadOnly = new Wrapper(impl)
}
