package zio.aws.keyspaces.model
import scala.jdk.CollectionConverters.*
sealed trait TimeToLiveStatus {
  def unwrap: software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus
}
object TimeToLiveStatus {
  def wrap(
      value: software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus
  ): zio.aws.keyspaces.model.TimeToLiveStatus = value match {
    case software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.keyspaces.model.TimeToLiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus =
      software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.keyspaces.model.TimeToLiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus =
      software.amazon.awssdk.services.keyspaces.model.TimeToLiveStatus.ENABLED
  }
}
