package zio.aws.keyspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.keyspaces.model.primitives.{Timestamp, TableName, KeyspaceName}
import scala.jdk.CollectionConverters.*
final case class RestoreTableRequest(
    sourceKeyspaceName: KeyspaceName,
    sourceTableName: TableName,
    targetKeyspaceName: KeyspaceName,
    targetTableName: TableName,
    restoreTimestamp: Optional[Timestamp] = Optional.Absent,
    capacitySpecificationOverride: Optional[
      zio.aws.keyspaces.model.CapacitySpecification
    ] = Optional.Absent,
    encryptionSpecificationOverride: Optional[
      zio.aws.keyspaces.model.EncryptionSpecification
    ] = Optional.Absent,
    pointInTimeRecoveryOverride: Optional[
      zio.aws.keyspaces.model.PointInTimeRecovery
    ] = Optional.Absent,
    tagsOverride: Optional[Iterable[zio.aws.keyspaces.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest = {
    import RestoreTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest
      .builder()
      .sourceKeyspaceName(
        KeyspaceName.unwrap(sourceKeyspaceName): java.lang.String
      )
      .sourceTableName(TableName.unwrap(sourceTableName): java.lang.String)
      .targetKeyspaceName(
        KeyspaceName.unwrap(targetKeyspaceName): java.lang.String
      )
      .targetTableName(TableName.unwrap(targetTableName): java.lang.String)
      .optionallyWith(
        restoreTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.restoreTimestamp)
      .optionallyWith(
        capacitySpecificationOverride.map(value => value.buildAwsValue())
      )(_.capacitySpecificationOverride)
      .optionallyWith(
        encryptionSpecificationOverride.map(value => value.buildAwsValue())
      )(_.encryptionSpecificationOverride)
      .optionallyWith(
        pointInTimeRecoveryOverride.map(value => value.buildAwsValue())
      )(_.pointInTimeRecoveryOverride)
      .optionallyWith(
        tagsOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagsOverride)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.RestoreTableRequest.ReadOnly =
    zio.aws.keyspaces.model.RestoreTableRequest.wrap(buildAwsValue())
}
object RestoreTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.RestoreTableRequest =
      zio.aws.keyspaces.model.RestoreTableRequest(
        sourceKeyspaceName,
        sourceTableName,
        targetKeyspaceName,
        targetTableName,
        restoreTimestamp.map(value => value),
        capacitySpecificationOverride.map(value => value.asEditable),
        encryptionSpecificationOverride.map(value => value.asEditable),
        pointInTimeRecoveryOverride.map(value => value.asEditable),
        tagsOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceKeyspaceName: KeyspaceName
    def sourceTableName: TableName
    def targetKeyspaceName: KeyspaceName
    def targetTableName: TableName
    def restoreTimestamp: Optional[Timestamp]
    def capacitySpecificationOverride
        : Optional[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly]
    def encryptionSpecificationOverride
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly]
    def pointInTimeRecoveryOverride
        : Optional[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly]
    def tagsOverride: Optional[List[zio.aws.keyspaces.model.Tag.ReadOnly]]
    def getSourceKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(sourceKeyspaceName)
    def getSourceTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(sourceTableName)
    def getTargetKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(targetKeyspaceName)
    def getTargetTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(targetTableName)
    def getRestoreTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("restoreTimestamp", restoreTimestamp)
    def getCapacitySpecificationOverride: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.CapacitySpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacitySpecificationOverride",
      capacitySpecificationOverride
    )
    def getEncryptionSpecificationOverride: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionSpecificationOverride",
      encryptionSpecificationOverride
    )
    def getPointInTimeRecoveryOverride: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pointInTimeRecoveryOverride",
      pointInTimeRecoveryOverride
    )
    def getTagsOverride
        : ZIO[Any, AwsError, List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagsOverride", tagsOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest
  ) extends zio.aws.keyspaces.model.RestoreTableRequest.ReadOnly {
    override val sourceKeyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.sourceKeyspaceName())
    override val sourceTableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.sourceTableName())
    override val targetKeyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.targetKeyspaceName())
    override val targetTableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.targetTableName())
    override val restoreTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreTimestamp())
      .map(value => zio.aws.keyspaces.model.primitives.Timestamp(value))
    override val capacitySpecificationOverride
        : Optional[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacitySpecificationOverride())
        .map(value => zio.aws.keyspaces.model.CapacitySpecification.wrap(value))
    override val encryptionSpecificationOverride
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionSpecificationOverride())
        .map(value =>
          zio.aws.keyspaces.model.EncryptionSpecification.wrap(value)
        )
    override val pointInTimeRecoveryOverride
        : Optional[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pointInTimeRecoveryOverride())
        .map(value => zio.aws.keyspaces.model.PointInTimeRecovery.wrap(value))
    override val tagsOverride
        : Optional[List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagsOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest
  ): zio.aws.keyspaces.model.RestoreTableRequest.ReadOnly = new Wrapper(impl)
}
