package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{ARN, TableName, KeyspaceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TableSummary(
    keyspaceName: KeyspaceName,
    tableName: TableName,
    resourceArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.TableSummary = {
    import TableSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.TableSummary
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.TableSummary.ReadOnly =
    zio.aws.keyspaces.model.TableSummary.wrap(buildAwsValue())
}
object TableSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.TableSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.TableSummary =
      zio.aws.keyspaces.model.TableSummary(keyspaceName, tableName, resourceArn)
    def keyspaceName: KeyspaceName
    def tableName: TableName
    def resourceArn: ARN
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.TableSummary
  ) extends zio.aws.keyspaces.model.TableSummary.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.tableName())
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.TableSummary
  ): zio.aws.keyspaces.model.TableSummary.ReadOnly = new Wrapper(impl)
}
