package zio.aws.keyspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TimeToLive(status: zio.aws.keyspaces.model.TimeToLiveStatus) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.TimeToLive = {
    import TimeToLive.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.TimeToLive
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.TimeToLive.ReadOnly =
    zio.aws.keyspaces.model.TimeToLive.wrap(buildAwsValue())
}
object TimeToLive {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.TimeToLive
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.TimeToLive =
      zio.aws.keyspaces.model.TimeToLive(status)
    def status: zio.aws.keyspaces.model.TimeToLiveStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.keyspaces.model.TimeToLiveStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.TimeToLive
  ) extends zio.aws.keyspaces.model.TimeToLive.ReadOnly {
    override val status: zio.aws.keyspaces.model.TimeToLiveStatus =
      zio.aws.keyspaces.model.TimeToLiveStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.TimeToLive
  ): zio.aws.keyspaces.model.TimeToLive.ReadOnly = new Wrapper(impl)
}
