package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.CapacityUnits
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CapacitySpecification(
    throughputMode: zio.aws.keyspaces.model.ThroughputMode,
    readCapacityUnits: Optional[CapacityUnits] = Optional.Absent,
    writeCapacityUnits: Optional[CapacityUnits] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.CapacitySpecification = {
    import CapacitySpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.CapacitySpecification
      .builder()
      .throughputMode(throughputMode.unwrap)
      .optionallyWith(
        readCapacityUnits.map(value =>
          CapacityUnits.unwrap(value): java.lang.Long
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          CapacityUnits.unwrap(value): java.lang.Long
        )
      )(_.writeCapacityUnits)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.CapacitySpecification.ReadOnly =
    zio.aws.keyspaces.model.CapacitySpecification.wrap(buildAwsValue())
}
object CapacitySpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.CapacitySpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.CapacitySpecification =
      zio.aws.keyspaces.model.CapacitySpecification(
        throughputMode,
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value)
      )
    def throughputMode: zio.aws.keyspaces.model.ThroughputMode
    def readCapacityUnits: Optional[CapacityUnits]
    def writeCapacityUnits: Optional[CapacityUnits]
    def getThroughputMode
        : ZIO[Any, Nothing, zio.aws.keyspaces.model.ThroughputMode] =
      ZIO.succeed(throughputMode)
    def getReadCapacityUnits: ZIO[Any, AwsError, CapacityUnits] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, CapacityUnits] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.CapacitySpecification
  ) extends zio.aws.keyspaces.model.CapacitySpecification.ReadOnly {
    override val throughputMode: zio.aws.keyspaces.model.ThroughputMode =
      zio.aws.keyspaces.model.ThroughputMode.wrap(impl.throughputMode())
    override val readCapacityUnits: Optional[CapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readCapacityUnits())
        .map(value => zio.aws.keyspaces.model.primitives.CapacityUnits(value))
    override val writeCapacityUnits: Optional[CapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeCapacityUnits())
        .map(value => zio.aws.keyspaces.model.primitives.CapacityUnits(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.CapacitySpecification
  ): zio.aws.keyspaces.model.CapacitySpecification.ReadOnly = new Wrapper(impl)
}
