package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateTableResponse(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.CreateTableResponse = {
    import CreateTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.CreateTableResponse
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.CreateTableResponse.ReadOnly =
    zio.aws.keyspaces.model.CreateTableResponse.wrap(buildAwsValue())
}
object CreateTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.CreateTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.CreateTableResponse =
      zio.aws.keyspaces.model.CreateTableResponse(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateTableResponse
  ) extends zio.aws.keyspaces.model.CreateTableResponse.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateTableResponse
  ): zio.aws.keyspaces.model.CreateTableResponse.ReadOnly = new Wrapper(impl)
}
