package zio.aws.keyspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SchemaDefinition(
    allColumns: Iterable[zio.aws.keyspaces.model.ColumnDefinition],
    partitionKeys: Iterable[zio.aws.keyspaces.model.PartitionKey],
    clusteringKeys: Optional[Iterable[zio.aws.keyspaces.model.ClusteringKey]] =
      Optional.Absent,
    staticColumns: Optional[Iterable[zio.aws.keyspaces.model.StaticColumn]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.SchemaDefinition = {
    import SchemaDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.SchemaDefinition
      .builder()
      .allColumns(allColumns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .partitionKeys(partitionKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clusteringKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusteringKeys)
      .optionallyWith(
        staticColumns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staticColumns)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.SchemaDefinition.ReadOnly =
    zio.aws.keyspaces.model.SchemaDefinition.wrap(buildAwsValue())
}
object SchemaDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.SchemaDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.SchemaDefinition =
      zio.aws.keyspaces.model.SchemaDefinition(
        allColumns.map { item =>
          item.asEditable
        },
        partitionKeys.map { item =>
          item.asEditable
        },
        clusteringKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        staticColumns.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allColumns: List[zio.aws.keyspaces.model.ColumnDefinition.ReadOnly]
    def partitionKeys: List[zio.aws.keyspaces.model.PartitionKey.ReadOnly]
    def clusteringKeys
        : Optional[List[zio.aws.keyspaces.model.ClusteringKey.ReadOnly]]
    def staticColumns
        : Optional[List[zio.aws.keyspaces.model.StaticColumn.ReadOnly]]
    def getAllColumns: ZIO[Any, Nothing, List[
      zio.aws.keyspaces.model.ColumnDefinition.ReadOnly
    ]] = ZIO.succeed(allColumns)
    def getPartitionKeys: ZIO[Any, Nothing, List[
      zio.aws.keyspaces.model.PartitionKey.ReadOnly
    ]] = ZIO.succeed(partitionKeys)
    def getClusteringKeys: ZIO[Any, AwsError, List[
      zio.aws.keyspaces.model.ClusteringKey.ReadOnly
    ]] = AwsError.unwrapOptionField("clusteringKeys", clusteringKeys)
    def getStaticColumns: ZIO[Any, AwsError, List[
      zio.aws.keyspaces.model.StaticColumn.ReadOnly
    ]] = AwsError.unwrapOptionField("staticColumns", staticColumns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.SchemaDefinition
  ) extends zio.aws.keyspaces.model.SchemaDefinition.ReadOnly {
    override val allColumns
        : List[zio.aws.keyspaces.model.ColumnDefinition.ReadOnly] = impl
      .allColumns()
      .asScala
      .map { item =>
        zio.aws.keyspaces.model.ColumnDefinition.wrap(item)
      }
      .toList
    override val partitionKeys
        : List[zio.aws.keyspaces.model.PartitionKey.ReadOnly] = impl
      .partitionKeys()
      .asScala
      .map { item =>
        zio.aws.keyspaces.model.PartitionKey.wrap(item)
      }
      .toList
    override val clusteringKeys
        : Optional[List[zio.aws.keyspaces.model.ClusteringKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusteringKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.ClusteringKey.wrap(item)
          }.toList
        )
    override val staticColumns
        : Optional[List[zio.aws.keyspaces.model.StaticColumn.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staticColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.StaticColumn.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.SchemaDefinition
  ): zio.aws.keyspaces.model.SchemaDefinition.ReadOnly = new Wrapper(impl)
}
