package zio.aws.keyspaces.model
import scala.jdk.CollectionConverters.*
sealed trait PointInTimeRecoveryStatus {
  def unwrap: software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus
}
object PointInTimeRecoveryStatus {
  def wrap(
      value: software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus
  ): zio.aws.keyspaces.model.PointInTimeRecoveryStatus = value match {
    case software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.keyspaces.model.PointInTimeRecoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus =
      software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.keyspaces.model.PointInTimeRecoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus =
      software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus.ENABLED
  }
  case object DISABLED
      extends zio.aws.keyspaces.model.PointInTimeRecoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus =
      software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoveryStatus.DISABLED
  }
}
