package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.KmsKeyARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EncryptionSpecification(
    `type`: zio.aws.keyspaces.model.EncryptionType,
    kmsKeyIdentifier: Optional[KmsKeyARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification = {
    import EncryptionSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        kmsKeyIdentifier.map(value => KmsKeyARN.unwrap(value): java.lang.String)
      )(_.kmsKeyIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly =
    zio.aws.keyspaces.model.EncryptionSpecification.wrap(buildAwsValue())
}
object EncryptionSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.EncryptionSpecification =
      zio.aws.keyspaces.model
        .EncryptionSpecification(`type`, kmsKeyIdentifier.map(value => value))
    def `type`: zio.aws.keyspaces.model.EncryptionType
    def kmsKeyIdentifier: Optional[KmsKeyARN]
    def getType: ZIO[Any, Nothing, zio.aws.keyspaces.model.EncryptionType] =
      ZIO.succeed(`type`)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyARN] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification
  ) extends zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly {
    override val `type`: zio.aws.keyspaces.model.EncryptionType =
      zio.aws.keyspaces.model.EncryptionType.wrap(impl.`type`())
    override val kmsKeyIdentifier: Optional[KmsKeyARN] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyIdentifier())
      .map(value => zio.aws.keyspaces.model.primitives.KmsKeyARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification
  ): zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly = new Wrapper(
    impl
  )
}
