package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: ARN,
    tags: Iterable[zio.aws.keyspaces.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.UntagResourceRequest.ReadOnly =
    zio.aws.keyspaces.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.UntagResourceRequest =
      zio.aws.keyspaces.model.UntagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ARN
    def tags: List[zio.aws.keyspaces.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest
  ) extends zio.aws.keyspaces.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
    override val tags: List[zio.aws.keyspaces.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.keyspaces.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest
  ): zio.aws.keyspaces.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
