package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{ARN, KeyspaceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KeyspaceSummary(keyspaceName: KeyspaceName, resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary = {
    import KeyspaceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly =
    zio.aws.keyspaces.model.KeyspaceSummary.wrap(buildAwsValue())
}
object KeyspaceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.KeyspaceSummary =
      zio.aws.keyspaces.model.KeyspaceSummary(keyspaceName, resourceArn)
    def keyspaceName: KeyspaceName
    def resourceArn: ARN
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
  ) extends zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
  ): zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly = new Wrapper(impl)
}
