package zio.aws.keyspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.keyspaces.model.primitives.{
  KeyspaceName,
  TableName,
  Timestamp,
  DefaultTimeToLive,
  ARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetTableResponse(
    keyspaceName: KeyspaceName,
    tableName: TableName,
    resourceArn: ARN,
    creationTimestamp: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.keyspaces.model.TableStatus] = Optional.Absent,
    schemaDefinition: Optional[zio.aws.keyspaces.model.SchemaDefinition] =
      Optional.Absent,
    capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecificationSummary
    ] = Optional.Absent,
    encryptionSpecification: Optional[
      zio.aws.keyspaces.model.EncryptionSpecification
    ] = Optional.Absent,
    pointInTimeRecovery: Optional[
      zio.aws.keyspaces.model.PointInTimeRecoverySummary
    ] = Optional.Absent,
    ttl: Optional[zio.aws.keyspaces.model.TimeToLive] = Optional.Absent,
    defaultTimeToLive: Optional[DefaultTimeToLive] = Optional.Absent,
    comment: Optional[zio.aws.keyspaces.model.Comment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.GetTableResponse = {
    import GetTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.GetTableResponse
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(schemaDefinition.map(value => value.buildAwsValue()))(
        _.schemaDefinition
      )
      .optionallyWith(
        capacitySpecification.map(value => value.buildAwsValue())
      )(_.capacitySpecification)
      .optionallyWith(
        encryptionSpecification.map(value => value.buildAwsValue())
      )(_.encryptionSpecification)
      .optionallyWith(pointInTimeRecovery.map(value => value.buildAwsValue()))(
        _.pointInTimeRecovery
      )
      .optionallyWith(ttl.map(value => value.buildAwsValue()))(_.ttl)
      .optionallyWith(
        defaultTimeToLive.map(value => DefaultTimeToLive.unwrap(value): Integer)
      )(_.defaultTimeToLive)
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.GetTableResponse.ReadOnly =
    zio.aws.keyspaces.model.GetTableResponse.wrap(buildAwsValue())
}
object GetTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.GetTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.GetTableResponse =
      zio.aws.keyspaces.model.GetTableResponse(
        keyspaceName,
        tableName,
        resourceArn,
        creationTimestamp.map(value => value),
        status.map(value => value),
        schemaDefinition.map(value => value.asEditable),
        capacitySpecification.map(value => value.asEditable),
        encryptionSpecification.map(value => value.asEditable),
        pointInTimeRecovery.map(value => value.asEditable),
        ttl.map(value => value.asEditable),
        defaultTimeToLive.map(value => value),
        comment.map(value => value.asEditable)
      )
    def keyspaceName: KeyspaceName
    def tableName: TableName
    def resourceArn: ARN
    def creationTimestamp: Optional[Timestamp]
    def status: Optional[zio.aws.keyspaces.model.TableStatus]
    def schemaDefinition
        : Optional[zio.aws.keyspaces.model.SchemaDefinition.ReadOnly]
    def capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly
    ]
    def encryptionSpecification
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly]
    def pointInTimeRecovery
        : Optional[zio.aws.keyspaces.model.PointInTimeRecoverySummary.ReadOnly]
    def ttl: Optional[zio.aws.keyspaces.model.TimeToLive.ReadOnly]
    def defaultTimeToLive: Optional[DefaultTimeToLive]
    def comment: Optional[zio.aws.keyspaces.model.Comment.ReadOnly]
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getStatus: ZIO[Any, AwsError, zio.aws.keyspaces.model.TableStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSchemaDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.SchemaDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("schemaDefinition", schemaDefinition)
    def getCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly
    ] =
      AwsError.unwrapOptionField("capacitySpecification", capacitySpecification)
    def getEncryptionSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionSpecification",
      encryptionSpecification
    )
    def getPointInTimeRecovery: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.PointInTimeRecoverySummary.ReadOnly
    ] = AwsError.unwrapOptionField("pointInTimeRecovery", pointInTimeRecovery)
    def getTtl
        : ZIO[Any, AwsError, zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getDefaultTimeToLive: ZIO[Any, AwsError, DefaultTimeToLive] =
      AwsError.unwrapOptionField("defaultTimeToLive", defaultTimeToLive)
    def getComment
        : ZIO[Any, AwsError, zio.aws.keyspaces.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.GetTableResponse
  ) extends zio.aws.keyspaces.model.GetTableResponse.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.tableName())
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
    override val creationTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.keyspaces.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.keyspaces.model.TableStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.keyspaces.model.TableStatus.wrap(value))
    override val schemaDefinition
        : Optional[zio.aws.keyspaces.model.SchemaDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaDefinition())
        .map(value => zio.aws.keyspaces.model.SchemaDefinition.wrap(value))
    override val capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacitySpecification())
      .map(value =>
        zio.aws.keyspaces.model.CapacitySpecificationSummary.wrap(value)
      )
    override val encryptionSpecification
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionSpecification())
        .map(value =>
          zio.aws.keyspaces.model.EncryptionSpecification.wrap(value)
        )
    override val pointInTimeRecovery: Optional[
      zio.aws.keyspaces.model.PointInTimeRecoverySummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pointInTimeRecovery())
      .map(value =>
        zio.aws.keyspaces.model.PointInTimeRecoverySummary.wrap(value)
      )
    override val ttl: Optional[zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ttl())
        .map(value => zio.aws.keyspaces.model.TimeToLive.wrap(value))
    override val defaultTimeToLive: Optional[DefaultTimeToLive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultTimeToLive())
        .map(value =>
          zio.aws.keyspaces.model.primitives.DefaultTimeToLive(value)
        )
    override val comment: Optional[zio.aws.keyspaces.model.Comment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.keyspaces.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.GetTableResponse
  ): zio.aws.keyspaces.model.GetTableResponse.ReadOnly = new Wrapper(impl)
}
