package zio.aws.keyspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PointInTimeRecovery(
    status: zio.aws.keyspaces.model.PointInTimeRecoveryStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.PointInTimeRecovery = {
    import PointInTimeRecovery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.PointInTimeRecovery
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly =
    zio.aws.keyspaces.model.PointInTimeRecovery.wrap(buildAwsValue())
}
object PointInTimeRecovery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.PointInTimeRecovery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.PointInTimeRecovery =
      zio.aws.keyspaces.model.PointInTimeRecovery(status)
    def status: zio.aws.keyspaces.model.PointInTimeRecoveryStatus
    def getStatus
        : ZIO[Any, Nothing, zio.aws.keyspaces.model.PointInTimeRecoveryStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.PointInTimeRecovery
  ) extends zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly {
    override val status: zio.aws.keyspaces.model.PointInTimeRecoveryStatus =
      zio.aws.keyspaces.model.PointInTimeRecoveryStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.PointInTimeRecovery
  ): zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly = new Wrapper(impl)
}
