package zio.aws.keyspaces.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.keyspaces.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.keyspaces.model.EncryptionType
  ): zio.aws.keyspaces.model.EncryptionType = value match {
    case software.amazon.awssdk.services.keyspaces.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.keyspaces.model.EncryptionType.CUSTOMER_MANAGED_KMS_KEY =>
      val r = CUSTOMER_MANAGED_KMS_KEY
      r
    case software.amazon.awssdk.services.keyspaces.model.EncryptionType.AWS_OWNED_KMS_KEY =>
      val r = AWS_OWNED_KMS_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.keyspaces.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.EncryptionType =
      software.amazon.awssdk.services.keyspaces.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_MANAGED_KMS_KEY
      extends zio.aws.keyspaces.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.EncryptionType =
      software.amazon.awssdk.services.keyspaces.model.EncryptionType.CUSTOMER_MANAGED_KMS_KEY
  }
  case object AWS_OWNED_KMS_KEY extends zio.aws.keyspaces.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.EncryptionType =
      software.amazon.awssdk.services.keyspaces.model.EncryptionType.AWS_OWNED_KMS_KEY
  }
}
