package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTablesResponse(
    nextToken: Option[NextToken] = None,
    tables: Option[Iterable[zio.aws.keyspaces.model.TableSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ListTablesResponse = {
    import ListTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ListTablesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tables)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ListTablesResponse.ReadOnly =
    zio.aws.keyspaces.model.ListTablesResponse.wrap(buildAwsValue())
}
object ListTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ListTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ListTablesResponse =
      zio.aws.keyspaces.model.ListTablesResponse(
        nextToken.map(value => value),
        tables.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def tables: Option[List[zio.aws.keyspaces.model.TableSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTables: ZIO[Any, AwsError, List[
      zio.aws.keyspaces.model.TableSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("tables", tables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTablesResponse
  ) extends zio.aws.keyspaces.model.ListTablesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.keyspaces.model.primitives.NextToken(value))
    override val tables
        : Option[List[zio.aws.keyspaces.model.TableSummary.ReadOnly]] = scala
      .Option(impl.tables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.keyspaces.model.TableSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTablesResponse
  ): zio.aws.keyspaces.model.ListTablesResponse.ReadOnly = new Wrapper(impl)
}
