package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{Timestamp, CapacityUnits}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CapacitySpecificationSummary(
    throughputMode: zio.aws.keyspaces.model.ThroughputMode,
    readCapacityUnits: Option[CapacityUnits] = None,
    writeCapacityUnits: Option[CapacityUnits] = None,
    lastUpdateToPayPerRequestTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.CapacitySpecificationSummary = {
    import CapacitySpecificationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.CapacitySpecificationSummary
      .builder()
      .throughputMode(throughputMode.unwrap)
      .optionallyWith(
        readCapacityUnits.map(value =>
          CapacityUnits.unwrap(value): java.lang.Long
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          CapacityUnits.unwrap(value): java.lang.Long
        )
      )(_.writeCapacityUnits)
      .optionallyWith(
        lastUpdateToPayPerRequestTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastUpdateToPayPerRequestTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly =
    zio.aws.keyspaces.model.CapacitySpecificationSummary.wrap(buildAwsValue())
}
object CapacitySpecificationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.CapacitySpecificationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.CapacitySpecificationSummary =
      zio.aws.keyspaces.model.CapacitySpecificationSummary(
        throughputMode,
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value),
        lastUpdateToPayPerRequestTimestamp.map(value => value)
      )
    def throughputMode: zio.aws.keyspaces.model.ThroughputMode
    def readCapacityUnits: Option[CapacityUnits]
    def writeCapacityUnits: Option[CapacityUnits]
    def lastUpdateToPayPerRequestTimestamp: Option[Timestamp]
    def getThroughputMode
        : ZIO[Any, Nothing, zio.aws.keyspaces.model.ThroughputMode] =
      ZIO.succeed(throughputMode)
    def getReadCapacityUnits: ZIO[Any, AwsError, CapacityUnits] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, CapacityUnits] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
    def getLastUpdateToPayPerRequestTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastUpdateToPayPerRequestTimestamp",
        lastUpdateToPayPerRequestTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.CapacitySpecificationSummary
  ) extends zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly {
    override val throughputMode: zio.aws.keyspaces.model.ThroughputMode =
      zio.aws.keyspaces.model.ThroughputMode.wrap(impl.throughputMode())
    override val readCapacityUnits: Option[CapacityUnits] = scala
      .Option(impl.readCapacityUnits())
      .map(value => zio.aws.keyspaces.model.primitives.CapacityUnits(value))
    override val writeCapacityUnits: Option[CapacityUnits] = scala
      .Option(impl.writeCapacityUnits())
      .map(value => zio.aws.keyspaces.model.primitives.CapacityUnits(value))
    override val lastUpdateToPayPerRequestTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdateToPayPerRequestTimestamp())
      .map(value => zio.aws.keyspaces.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.CapacitySpecificationSummary
  ): zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly =
    new Wrapper(impl)
}
