package zio.aws.keyspaces.model
import java.lang.Integer
import zio.aws.keyspaces.model.primitives.{
  DefaultTimeToLive,
  TableName,
  KeyspaceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateTableRequest(
    keyspaceName: KeyspaceName,
    tableName: TableName,
    addColumns: Option[Iterable[zio.aws.keyspaces.model.ColumnDefinition]] =
      None,
    capacitySpecification: Option[
      zio.aws.keyspaces.model.CapacitySpecification
    ] = None,
    encryptionSpecification: Option[
      zio.aws.keyspaces.model.EncryptionSpecification
    ] = None,
    pointInTimeRecovery: Option[zio.aws.keyspaces.model.PointInTimeRecovery] =
      None,
    ttl: Option[zio.aws.keyspaces.model.TimeToLive] = None,
    defaultTimeToLive: Option[DefaultTimeToLive] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest = {
    import UpdateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        addColumns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addColumns)
      .optionallyWith(
        capacitySpecification.map(value => value.buildAwsValue())
      )(_.capacitySpecification)
      .optionallyWith(
        encryptionSpecification.map(value => value.buildAwsValue())
      )(_.encryptionSpecification)
      .optionallyWith(pointInTimeRecovery.map(value => value.buildAwsValue()))(
        _.pointInTimeRecovery
      )
      .optionallyWith(ttl.map(value => value.buildAwsValue()))(_.ttl)
      .optionallyWith(
        defaultTimeToLive.map(value => DefaultTimeToLive.unwrap(value): Integer)
      )(_.defaultTimeToLive)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.UpdateTableRequest.ReadOnly =
    zio.aws.keyspaces.model.UpdateTableRequest.wrap(buildAwsValue())
}
object UpdateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.UpdateTableRequest =
      zio.aws.keyspaces.model.UpdateTableRequest(
        keyspaceName,
        tableName,
        addColumns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capacitySpecification.map(value => value.asEditable),
        encryptionSpecification.map(value => value.asEditable),
        pointInTimeRecovery.map(value => value.asEditable),
        ttl.map(value => value.asEditable),
        defaultTimeToLive.map(value => value)
      )
    def keyspaceName: KeyspaceName
    def tableName: TableName
    def addColumns
        : Option[List[zio.aws.keyspaces.model.ColumnDefinition.ReadOnly]]
    def capacitySpecification
        : Option[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly]
    def encryptionSpecification
        : Option[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly]
    def pointInTimeRecovery
        : Option[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly]
    def ttl: Option[zio.aws.keyspaces.model.TimeToLive.ReadOnly]
    def defaultTimeToLive: Option[DefaultTimeToLive]
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getAddColumns: ZIO[Any, AwsError, List[
      zio.aws.keyspaces.model.ColumnDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("addColumns", addColumns)
    def getCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.CapacitySpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("capacitySpecification", capacitySpecification)
    def getEncryptionSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionSpecification",
      encryptionSpecification
    )
    def getPointInTimeRecovery: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly
    ] = AwsError.unwrapOptionField("pointInTimeRecovery", pointInTimeRecovery)
    def getTtl
        : ZIO[Any, AwsError, zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getDefaultTimeToLive: ZIO[Any, AwsError, DefaultTimeToLive] =
      AwsError.unwrapOptionField("defaultTimeToLive", defaultTimeToLive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
  ) extends zio.aws.keyspaces.model.UpdateTableRequest.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.tableName())
    override val addColumns
        : Option[List[zio.aws.keyspaces.model.ColumnDefinition.ReadOnly]] =
      scala
        .Option(impl.addColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.ColumnDefinition.wrap(item)
          }.toList
        )
    override val capacitySpecification
        : Option[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly] = scala
      .Option(impl.capacitySpecification())
      .map(value => zio.aws.keyspaces.model.CapacitySpecification.wrap(value))
    override val encryptionSpecification
        : Option[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly] =
      scala
        .Option(impl.encryptionSpecification())
        .map(value =>
          zio.aws.keyspaces.model.EncryptionSpecification.wrap(value)
        )
    override val pointInTimeRecovery
        : Option[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly] = scala
      .Option(impl.pointInTimeRecovery())
      .map(value => zio.aws.keyspaces.model.PointInTimeRecovery.wrap(value))
    override val ttl: Option[zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      scala
        .Option(impl.ttl())
        .map(value => zio.aws.keyspaces.model.TimeToLive.wrap(value))
    override val defaultTimeToLive: Option[DefaultTimeToLive] = scala
      .Option(impl.defaultTimeToLive())
      .map(value => zio.aws.keyspaces.model.primitives.DefaultTimeToLive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest
  ): zio.aws.keyspaces.model.UpdateTableRequest.ReadOnly = new Wrapper(impl)
}
