package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    nextToken: Option[NextToken] = None,
    tags: Option[Iterable[zio.aws.keyspaces.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.keyspaces.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ListTagsForResourceResponse =
      zio.aws.keyspaces.model.ListTagsForResourceResponse(
        nextToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def tags: Option[List[zio.aws.keyspaces.model.Tag.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse
  ) extends zio.aws.keyspaces.model.ListTagsForResourceResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.keyspaces.model.primitives.NextToken(value))
    override val tags: Option[List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse
  ): zio.aws.keyspaces.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
