package zio.aws.keyspaces.model
import java.lang.Integer
import zio.aws.keyspaces.model.primitives.{KeyspaceName, MaxResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTablesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    keyspaceName: KeyspaceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ListTablesRequest = {
    import ListTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ListTablesRequest.ReadOnly =
    zio.aws.keyspaces.model.ListTablesRequest.wrap(buildAwsValue())
}
object ListTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ListTablesRequest =
      zio.aws.keyspaces.model.ListTablesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        keyspaceName
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def keyspaceName: KeyspaceName
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
  ) extends zio.aws.keyspaces.model.ListTablesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.keyspaces.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.keyspaces.model.primitives.MaxResults(value))
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
  ): zio.aws.keyspaces.model.ListTablesRequest.ReadOnly = new Wrapper(impl)
}
