package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreTableResponse(restoredTableARN: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse = {
    import RestoreTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse
      .builder()
      .restoredTableARN(ARN.unwrap(restoredTableARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly =
    zio.aws.keyspaces.model.RestoreTableResponse.wrap(buildAwsValue())
}
object RestoreTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.RestoreTableResponse =
      zio.aws.keyspaces.model.RestoreTableResponse(restoredTableARN)
    def restoredTableARN: ARN
    def getRestoredTableARN: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(restoredTableARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse
  ) extends zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly {
    override val restoredTableARN: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.restoredTableARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse
  ): zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly = new Wrapper(impl)
}
