package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateTableResponse(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse = {
    import UpdateTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly =
    zio.aws.keyspaces.model.UpdateTableResponse.wrap(buildAwsValue())
}
object UpdateTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.UpdateTableResponse =
      zio.aws.keyspaces.model.UpdateTableResponse(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse
  ) extends zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse
  ): zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly = new Wrapper(impl)
}
