package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.GenericString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ColumnDefinition(name: GenericString, `type`: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ColumnDefinition = {
    import ColumnDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ColumnDefinition
      .builder()
      .name(name: java.lang.String)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ColumnDefinition.ReadOnly =
    zio.aws.keyspaces.model.ColumnDefinition.wrap(buildAwsValue())
}
object ColumnDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ColumnDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ColumnDefinition =
      zio.aws.keyspaces.model.ColumnDefinition(name, `type`)
    def name: GenericString
    def `type`: GenericString
    def getName: ZIO[Any, Nothing, GenericString] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, GenericString] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ColumnDefinition
  ) extends zio.aws.keyspaces.model.ColumnDefinition.ReadOnly {
    override val name: GenericString = impl.name(): GenericString
    override val `type`: GenericString = impl.`type`(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ColumnDefinition
  ): zio.aws.keyspaces.model.ColumnDefinition.ReadOnly = new Wrapper(impl)
}
