package zio.aws.keyspaces.model
import java.lang.Integer
import zio.aws.keyspaces.model.primitives.{MaxResults, NextToken, ARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceArn: ARN,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.keyspaces.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ListTagsForResourceRequest =
      zio.aws.keyspaces.model.ListTagsForResourceRequest(
        resourceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: ARN
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest
  ) extends zio.aws.keyspaces.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.keyspaces.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.keyspaces.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest
  ): zio.aws.keyspaces.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
