package zio.aws.keyspaces.model
import java.lang.Integer
import zio.aws.keyspaces.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListKeyspacesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest = {
    import ListKeyspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ListKeyspacesRequest.ReadOnly =
    zio.aws.keyspaces.model.ListKeyspacesRequest.wrap(buildAwsValue())
}
object ListKeyspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ListKeyspacesRequest =
      zio.aws.keyspaces.model.ListKeyspacesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest
  ) extends zio.aws.keyspaces.model.ListKeyspacesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.keyspaces.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.keyspaces.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest
  ): zio.aws.keyspaces.model.ListKeyspacesRequest.ReadOnly = new Wrapper(impl)
}
