package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{Region, ARN, KeyspaceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeyspaceSummary(
    keyspaceName: KeyspaceName,
    resourceArn: ARN,
    replicationStrategy: zio.aws.keyspaces.model.Rs,
    replicationRegions: Optional[Iterable[Region]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary = {
    import KeyspaceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .replicationStrategy(replicationStrategy.unwrap)
      .optionallyWith(
        replicationRegions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replicationRegions)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly =
    zio.aws.keyspaces.model.KeyspaceSummary.wrap(buildAwsValue())
}
object KeyspaceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.KeyspaceSummary =
      zio.aws.keyspaces.model.KeyspaceSummary(
        keyspaceName,
        resourceArn,
        replicationStrategy,
        replicationRegions.map(value => value)
      )
    def keyspaceName: KeyspaceName
    def resourceArn: ARN
    def replicationStrategy: zio.aws.keyspaces.model.Rs
    def replicationRegions: Optional[List[Region]]
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getReplicationStrategy: ZIO[Any, Nothing, zio.aws.keyspaces.model.Rs] =
      ZIO.succeed(replicationStrategy)
    def getReplicationRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("replicationRegions", replicationRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
  ) extends zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
    override val replicationStrategy: zio.aws.keyspaces.model.Rs =
      zio.aws.keyspaces.model.Rs.wrap(impl.replicationStrategy())
    override val replicationRegions: Optional[List[Region]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.primitives.Region(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary
  ): zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly = new Wrapper(impl)
}
