package zio.aws.keyspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.keyspaces.model.primitives.{KeyspaceName, MaxResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTablesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    keyspaceName: KeyspaceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ListTablesRequest = {
    import ListTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ListTablesRequest.ReadOnly =
    zio.aws.keyspaces.model.ListTablesRequest.wrap(buildAwsValue())
}
object ListTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ListTablesRequest =
      zio.aws.keyspaces.model.ListTablesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        keyspaceName
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def keyspaceName: KeyspaceName
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
  ) extends zio.aws.keyspaces.model.ListTablesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.keyspaces.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.keyspaces.model.primitives.MaxResults(value))
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ListTablesRequest
  ): zio.aws.keyspaces.model.ListTablesRequest.ReadOnly = new Wrapper(impl)
}
