package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.GenericString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PartitionKey(name: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.PartitionKey = {
    import PartitionKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.PartitionKey
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.PartitionKey.ReadOnly =
    zio.aws.keyspaces.model.PartitionKey.wrap(buildAwsValue())
}
object PartitionKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.PartitionKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.PartitionKey =
      zio.aws.keyspaces.model.PartitionKey(name)
    def name: GenericString
    def getName: ZIO[Any, Nothing, GenericString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.PartitionKey
  ) extends zio.aws.keyspaces.model.PartitionKey.ReadOnly {
    override val name: GenericString = impl.name(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.PartitionKey
  ): zio.aws.keyspaces.model.PartitionKey.ReadOnly = new Wrapper(impl)
}
