package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{ARN, KeyspaceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKeyspaceResponse(
    keyspaceName: KeyspaceName,
    resourceArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse = {
    import GetKeyspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly =
    zio.aws.keyspaces.model.GetKeyspaceResponse.wrap(buildAwsValue())
}
object GetKeyspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.GetKeyspaceResponse =
      zio.aws.keyspaces.model.GetKeyspaceResponse(keyspaceName, resourceArn)
    def keyspaceName: KeyspaceName
    def resourceArn: ARN
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse
  ) extends zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse
  ): zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly = new Wrapper(impl)
}
