package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.KeyspaceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteKeyspaceRequest(keyspaceName: KeyspaceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest = {
    import DeleteKeyspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.DeleteKeyspaceRequest.ReadOnly =
    zio.aws.keyspaces.model.DeleteKeyspaceRequest.wrap(buildAwsValue())
}
object DeleteKeyspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.DeleteKeyspaceRequest =
      zio.aws.keyspaces.model.DeleteKeyspaceRequest(keyspaceName)
    def keyspaceName: KeyspaceName
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest
  ) extends zio.aws.keyspaces.model.DeleteKeyspaceRequest.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest
  ): zio.aws.keyspaces.model.DeleteKeyspaceRequest.ReadOnly = new Wrapper(impl)
}
