package zio.aws.keyspaces
import zio.aws.keyspaces.model.ListTagsForResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.keyspaces.model.{
  GetTableRequest,
  ListTagsForResourceRequest,
  DeleteKeyspaceRequest,
  UpdateTableRequest,
  CreateTableRequest,
  CreateKeyspaceRequest,
  GetKeyspaceRequest,
  UntagResourceRequest,
  DeleteTableRequest,
  ListKeyspacesRequest,
  RestoreTableRequest,
  ListTablesRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.keyspaces.{
  KeyspacesAsyncClientBuilder,
  KeyspacesAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.keyspaces.paginators.{
  ListTagsForResourcePublisher,
  ListTablesPublisher,
  ListKeyspacesPublisher
}
import software.amazon.awssdk.services.keyspaces.model.{
  UpdateTableResponse,
  TableSummary,
  GetTableResponse,
  DeleteKeyspaceResponse,
  Tag,
  RestoreTableResponse,
  KeyspaceSummary,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListKeyspacesResponse,
  GetKeyspaceResponse,
  ListTablesResponse,
  TagResourceResponse,
  CreateKeyspaceResponse,
  DeleteTableResponse,
  CreateTableResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Keyspaces extends AspectSupport[Keyspaces] {
  val api: KeyspacesAsyncClient
  def getTable(
      request: GetTableRequest
  ): IO[AwsError, zio.aws.keyspaces.model.GetTableResponse.ReadOnly]
  def deleteKeyspace(
      request: DeleteKeyspaceRequest
  ): IO[AwsError, zio.aws.keyspaces.model.DeleteKeyspaceResponse.ReadOnly]
  def createTable(
      request: CreateTableRequest
  ): IO[AwsError, zio.aws.keyspaces.model.CreateTableResponse.ReadOnly]
  def deleteTable(
      request: DeleteTableRequest
  ): IO[AwsError, zio.aws.keyspaces.model.DeleteTableResponse.ReadOnly]
  def listKeyspaces(
      request: ListKeyspacesRequest
  ): ZStream[Any, AwsError, zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly]
  def listKeyspacesPaginated(
      request: ListKeyspacesRequest
  ): IO[AwsError, zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly]
  def getKeyspace(
      request: GetKeyspaceRequest
  ): IO[AwsError, zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly]
  def listTables(
      request: ListTablesRequest
  ): ZStream[Any, AwsError, zio.aws.keyspaces.model.TableSummary.ReadOnly]
  def listTablesPaginated(
      request: ListTablesRequest
  ): IO[AwsError, zio.aws.keyspaces.model.ListTablesResponse.ReadOnly]
  def updateTable(
      request: UpdateTableRequest
  ): IO[AwsError, zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.keyspaces.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.keyspaces.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.keyspaces.model.TagResourceResponse.ReadOnly]
  def restoreTable(
      request: RestoreTableRequest
  ): IO[AwsError, zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly]
  def createKeyspace(
      request: CreateKeyspaceRequest
  ): IO[AwsError, zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly]
}
object Keyspaces {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Keyspaces] = customized(
    identity
  )
  def customized(
      customization: KeyspacesAsyncClientBuilder => KeyspacesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Keyspaces] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: KeyspacesAsyncClientBuilder => KeyspacesAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Keyspaces] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = KeyspacesAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[KeyspacesAsyncClient, KeyspacesAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[KeyspacesAsyncClient, KeyspacesAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new KeyspacesImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class KeyspacesImpl[R](
      override val api: KeyspacesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Keyspaces
      with AwsServiceBase[R] {
    override val serviceName: String = "Keyspaces"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KeyspacesImpl[R1] = new KeyspacesImpl(api, newAspect, r)
    def getTable(
        request: GetTableRequest
    ): IO[AwsError, zio.aws.keyspaces.model.GetTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.GetTableRequest,
        GetTableResponse
      ]("getTable", api.getTable)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.GetTableResponse.wrap)
        .provideEnvironment(r)
    def deleteKeyspace(
        request: DeleteKeyspaceRequest
    ): IO[AwsError, zio.aws.keyspaces.model.DeleteKeyspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest,
        DeleteKeyspaceResponse
      ]("deleteKeyspace", api.deleteKeyspace)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.DeleteKeyspaceResponse.wrap)
        .provideEnvironment(r)
    def createTable(
        request: CreateTableRequest
    ): IO[AwsError, zio.aws.keyspaces.model.CreateTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.CreateTableRequest,
        CreateTableResponse
      ]("createTable", api.createTable)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.CreateTableResponse.wrap)
        .provideEnvironment(r)
    def deleteTable(
        request: DeleteTableRequest
    ): IO[AwsError, zio.aws.keyspaces.model.DeleteTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.DeleteTableRequest,
        DeleteTableResponse
      ]("deleteTable", api.deleteTable)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.DeleteTableResponse.wrap)
        .provideEnvironment(r)
    def listKeyspaces(request: ListKeyspacesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest,
      KeyspaceSummary,
      ListKeyspacesPublisher
    ]("listKeyspaces", api.listKeyspacesPaginator, _.keyspaces())(
      request.buildAwsValue()
    ).map(item => zio.aws.keyspaces.model.KeyspaceSummary.wrap(item))
      .provideEnvironment(r)
    def listKeyspacesPaginated(
        request: ListKeyspacesRequest
    ): IO[AwsError, zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest,
        ListKeyspacesResponse
      ]("listKeyspaces", api.listKeyspaces)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.ListKeyspacesResponse.wrap)
        .provideEnvironment(r)
    def getKeyspace(
        request: GetKeyspaceRequest
    ): IO[AwsError, zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest,
        GetKeyspaceResponse
      ]("getKeyspace", api.getKeyspace)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.GetKeyspaceResponse.wrap)
        .provideEnvironment(r)
    def listTables(
        request: ListTablesRequest
    ): ZStream[Any, AwsError, zio.aws.keyspaces.model.TableSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.keyspaces.model.ListTablesRequest,
        TableSummary,
        ListTablesPublisher
      ]("listTables", api.listTablesPaginator, _.tables())(
        request.buildAwsValue()
      ).map(item => zio.aws.keyspaces.model.TableSummary.wrap(item))
        .provideEnvironment(r)
    def listTablesPaginated(
        request: ListTablesRequest
    ): IO[AwsError, zio.aws.keyspaces.model.ListTablesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.ListTablesRequest,
        ListTablesResponse
      ]("listTables", api.listTables)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.ListTablesResponse.wrap)
        .provideEnvironment(r)
    def updateTable(
        request: UpdateTableRequest
    ): IO[AwsError, zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest,
        UpdateTableResponse
      ]("updateTable", api.updateTable)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.UpdateTableResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.keyspaces.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
      Any,
      AwsError,
      zio.aws.keyspaces.model.Tag.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest,
      Tag,
      ListTagsForResourcePublisher
    ]("listTagsForResource", api.listTagsForResourcePaginator, _.tags())(
      request.buildAwsValue()
    ).map(item => zio.aws.keyspaces.model.Tag.wrap(item)).provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: ListTagsForResourceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.keyspaces.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.keyspaces.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def restoreTable(
        request: RestoreTableRequest
    ): IO[AwsError, zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest,
        RestoreTableResponse
      ]("restoreTable", api.restoreTable)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.RestoreTableResponse.wrap)
        .provideEnvironment(r)
    def createKeyspace(
        request: CreateKeyspaceRequest
    ): IO[AwsError, zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest,
        CreateKeyspaceResponse
      ]("createKeyspace", api.createKeyspace)(request.buildAwsValue())
        .map(zio.aws.keyspaces.model.CreateKeyspaceResponse.wrap)
        .provideEnvironment(r)
  }
  def getTable(request: GetTableRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.GetTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTable(request))
  def deleteKeyspace(request: DeleteKeyspaceRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.DeleteKeyspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKeyspace(request))
  def createTable(request: CreateTableRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.CreateTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTable(request))
  def deleteTable(request: DeleteTableRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.DeleteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTable(request))
  def listKeyspaces(request: ListKeyspacesRequest): ZStream[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listKeyspaces(request))
  def listKeyspacesPaginated(request: ListKeyspacesRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeyspacesPaginated(request))
  def getKeyspace(request: GetKeyspaceRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKeyspace(request))
  def listTables(request: ListTablesRequest): ZStream[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.TableSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTables(request))
  def listTablesPaginated(request: ListTablesRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.ListTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTablesPaginated(request))
  def updateTable(request: UpdateTableRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTable(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): ZIO[zio.aws.keyspaces.Keyspaces, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def restoreTable(request: RestoreTableRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreTable(request))
  def createKeyspace(request: CreateKeyspaceRequest): ZIO[
    zio.aws.keyspaces.Keyspaces,
    AwsError,
    zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKeyspace(request))
}
