package zio.aws.keyspaces.model
import scala.jdk.CollectionConverters._
sealed trait TableStatus {
  def unwrap: software.amazon.awssdk.services.keyspaces.model.TableStatus
}
object TableStatus {
  def wrap(
      value: software.amazon.awssdk.services.keyspaces.model.TableStatus
  ): zio.aws.keyspaces.model.TableStatus = value match {
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.RESTORING =>
      val r = RESTORING
      r
    case software.amazon.awssdk.services.keyspaces.model.TableStatus.INACCESSIBLE_ENCRYPTION_CREDENTIALS =>
      val r = INACCESSIBLE_ENCRYPTION_CREDENTIALS
      r
  }
  case object unknownToSdkVersion extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.ACTIVE
  }
  case object CREATING extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.CREATING
  }
  case object UPDATING extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.UPDATING
  }
  case object DELETING extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.DELETING
  }
  case object DELETED extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.DELETED
  }
  case object RESTORING extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.RESTORING
  }
  case object INACCESSIBLE_ENCRYPTION_CREDENTIALS
      extends zio.aws.keyspaces.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.TableStatus =
      software.amazon.awssdk.services.keyspaces.model.TableStatus.INACCESSIBLE_ENCRYPTION_CREDENTIALS
  }
}
