package zio.aws.keyspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.keyspaces.model.primitives.{
  DefaultTimeToLive,
  TableName,
  KeyspaceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateTableRequest(
    keyspaceName: KeyspaceName,
    tableName: TableName,
    schemaDefinition: zio.aws.keyspaces.model.SchemaDefinition,
    comment: Optional[zio.aws.keyspaces.model.Comment] = Optional.Absent,
    capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecification
    ] = Optional.Absent,
    encryptionSpecification: Optional[
      zio.aws.keyspaces.model.EncryptionSpecification
    ] = Optional.Absent,
    pointInTimeRecovery: Optional[zio.aws.keyspaces.model.PointInTimeRecovery] =
      Optional.Absent,
    ttl: Optional[zio.aws.keyspaces.model.TimeToLive] = Optional.Absent,
    defaultTimeToLive: Optional[DefaultTimeToLive] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.keyspaces.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.CreateTableRequest = {
    import CreateTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.CreateTableRequest
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .schemaDefinition(schemaDefinition.buildAwsValue())
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .optionallyWith(
        capacitySpecification.map(value => value.buildAwsValue())
      )(_.capacitySpecification)
      .optionallyWith(
        encryptionSpecification.map(value => value.buildAwsValue())
      )(_.encryptionSpecification)
      .optionallyWith(pointInTimeRecovery.map(value => value.buildAwsValue()))(
        _.pointInTimeRecovery
      )
      .optionallyWith(ttl.map(value => value.buildAwsValue()))(_.ttl)
      .optionallyWith(
        defaultTimeToLive.map(value => DefaultTimeToLive.unwrap(value): Integer)
      )(_.defaultTimeToLive)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.CreateTableRequest.ReadOnly =
    zio.aws.keyspaces.model.CreateTableRequest.wrap(buildAwsValue())
}
object CreateTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.CreateTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.CreateTableRequest =
      zio.aws.keyspaces.model.CreateTableRequest(
        keyspaceName,
        tableName,
        schemaDefinition.asEditable,
        comment.map(value => value.asEditable),
        capacitySpecification.map(value => value.asEditable),
        encryptionSpecification.map(value => value.asEditable),
        pointInTimeRecovery.map(value => value.asEditable),
        ttl.map(value => value.asEditable),
        defaultTimeToLive.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyspaceName: KeyspaceName
    def tableName: TableName
    def schemaDefinition: zio.aws.keyspaces.model.SchemaDefinition.ReadOnly
    def comment: Optional[zio.aws.keyspaces.model.Comment.ReadOnly]
    def capacitySpecification
        : Optional[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly]
    def encryptionSpecification
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly]
    def pointInTimeRecovery
        : Optional[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly]
    def ttl: Optional[zio.aws.keyspaces.model.TimeToLive.ReadOnly]
    def defaultTimeToLive: Optional[DefaultTimeToLive]
    def tags: Optional[List[zio.aws.keyspaces.model.Tag.ReadOnly]]
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getSchemaDefinition
        : ZIO[Any, Nothing, zio.aws.keyspaces.model.SchemaDefinition.ReadOnly] =
      ZIO.succeed(schemaDefinition)
    def getComment
        : ZIO[Any, AwsError, zio.aws.keyspaces.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
    def getCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.CapacitySpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("capacitySpecification", capacitySpecification)
    def getEncryptionSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionSpecification",
      encryptionSpecification
    )
    def getPointInTimeRecovery: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly
    ] = AwsError.unwrapOptionField("pointInTimeRecovery", pointInTimeRecovery)
    def getTtl
        : ZIO[Any, AwsError, zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getDefaultTimeToLive: ZIO[Any, AwsError, DefaultTimeToLive] =
      AwsError.unwrapOptionField("defaultTimeToLive", defaultTimeToLive)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateTableRequest
  ) extends zio.aws.keyspaces.model.CreateTableRequest.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.tableName())
    override val schemaDefinition
        : zio.aws.keyspaces.model.SchemaDefinition.ReadOnly =
      zio.aws.keyspaces.model.SchemaDefinition.wrap(impl.schemaDefinition())
    override val comment: Optional[zio.aws.keyspaces.model.Comment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.keyspaces.model.Comment.wrap(value))
    override val capacitySpecification
        : Optional[zio.aws.keyspaces.model.CapacitySpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacitySpecification())
        .map(value => zio.aws.keyspaces.model.CapacitySpecification.wrap(value))
    override val encryptionSpecification
        : Optional[zio.aws.keyspaces.model.EncryptionSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionSpecification())
        .map(value =>
          zio.aws.keyspaces.model.EncryptionSpecification.wrap(value)
        )
    override val pointInTimeRecovery
        : Optional[zio.aws.keyspaces.model.PointInTimeRecovery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pointInTimeRecovery())
        .map(value => zio.aws.keyspaces.model.PointInTimeRecovery.wrap(value))
    override val ttl: Optional[zio.aws.keyspaces.model.TimeToLive.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ttl())
        .map(value => zio.aws.keyspaces.model.TimeToLive.wrap(value))
    override val defaultTimeToLive: Optional[DefaultTimeToLive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultTimeToLive())
        .map(value =>
          zio.aws.keyspaces.model.primitives.DefaultTimeToLive(value)
        )
    override val tags: Optional[List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateTableRequest
  ): zio.aws.keyspaces.model.CreateTableRequest.ReadOnly = new Wrapper(impl)
}
