package zio.aws.keyspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.keyspaces.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class PointInTimeRecoverySummary(
    status: zio.aws.keyspaces.model.PointInTimeRecoveryStatus,
    earliestRestorableTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoverySummary = {
    import PointInTimeRecoverySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoverySummary
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        earliestRestorableTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.earliestRestorableTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.PointInTimeRecoverySummary.ReadOnly =
    zio.aws.keyspaces.model.PointInTimeRecoverySummary.wrap(buildAwsValue())
}
object PointInTimeRecoverySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoverySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.PointInTimeRecoverySummary =
      zio.aws.keyspaces.model.PointInTimeRecoverySummary(
        status,
        earliestRestorableTimestamp.map(value => value)
      )
    def status: zio.aws.keyspaces.model.PointInTimeRecoveryStatus
    def earliestRestorableTimestamp: Optional[Timestamp]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.keyspaces.model.PointInTimeRecoveryStatus] =
      ZIO.succeed(status)
    def getEarliestRestorableTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "earliestRestorableTimestamp",
        earliestRestorableTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoverySummary
  ) extends zio.aws.keyspaces.model.PointInTimeRecoverySummary.ReadOnly {
    override val status: zio.aws.keyspaces.model.PointInTimeRecoveryStatus =
      zio.aws.keyspaces.model.PointInTimeRecoveryStatus.wrap(impl.status())
    override val earliestRestorableTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.earliestRestorableTimestamp())
        .map(value => zio.aws.keyspaces.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoverySummary
  ): zio.aws.keyspaces.model.PointInTimeRecoverySummary.ReadOnly = new Wrapper(
    impl
  )
}
