package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateReplicationInfoResponse(
    replicatorArn: Optional[__string] = Optional.Absent,
    replicatorState: Optional[zio.aws.kafka.model.ReplicatorState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoResponse = {
    import UpdateReplicationInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoResponse
      .builder()
      .optionallyWith(replicatorArn.map(value => value: java.lang.String))(
        _.replicatorArn
      )
      .optionallyWith(replicatorState.map(value => value.unwrap))(
        _.replicatorState
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateReplicationInfoResponse.ReadOnly =
    zio.aws.kafka.model.UpdateReplicationInfoResponse.wrap(buildAwsValue())
}
object UpdateReplicationInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateReplicationInfoResponse =
      zio.aws.kafka.model.UpdateReplicationInfoResponse(
        replicatorArn.map(value => value),
        replicatorState.map(value => value)
      )
    def replicatorArn: Optional[__string]
    def replicatorState: Optional[zio.aws.kafka.model.ReplicatorState]
    def getReplicatorArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("replicatorArn", replicatorArn)
    def getReplicatorState
        : ZIO[Any, AwsError, zio.aws.kafka.model.ReplicatorState] =
      AwsError.unwrapOptionField("replicatorState", replicatorState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoResponse
  ) extends zio.aws.kafka.model.UpdateReplicationInfoResponse.ReadOnly {
    override val replicatorArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorArn())
      .map(value => value: __string)
    override val replicatorState
        : Optional[zio.aws.kafka.model.ReplicatorState] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatorState())
      .map(value => zio.aws.kafka.model.ReplicatorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoResponse
  ): zio.aws.kafka.model.UpdateReplicationInfoResponse.ReadOnly = new Wrapper(
    impl
  )
}
