package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateReplicationInfoRequest(
    consumerGroupReplication: Optional[
      zio.aws.kafka.model.ConsumerGroupReplicationUpdate
    ] = Optional.Absent,
    currentVersion: __string,
    replicatorArn: __string,
    sourceKafkaClusterArn: __string,
    targetKafkaClusterArn: __string,
    topicReplication: Optional[zio.aws.kafka.model.TopicReplicationUpdate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest = {
    import UpdateReplicationInfoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest
      .builder()
      .optionallyWith(
        consumerGroupReplication.map(value => value.buildAwsValue())
      )(_.consumerGroupReplication)
      .currentVersion(currentVersion: java.lang.String)
      .replicatorArn(replicatorArn: java.lang.String)
      .sourceKafkaClusterArn(sourceKafkaClusterArn: java.lang.String)
      .targetKafkaClusterArn(targetKafkaClusterArn: java.lang.String)
      .optionallyWith(topicReplication.map(value => value.buildAwsValue()))(
        _.topicReplication
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateReplicationInfoRequest.ReadOnly =
    zio.aws.kafka.model.UpdateReplicationInfoRequest.wrap(buildAwsValue())
}
object UpdateReplicationInfoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateReplicationInfoRequest =
      zio.aws.kafka.model.UpdateReplicationInfoRequest(
        consumerGroupReplication.map(value => value.asEditable),
        currentVersion,
        replicatorArn,
        sourceKafkaClusterArn,
        targetKafkaClusterArn,
        topicReplication.map(value => value.asEditable)
      )
    def consumerGroupReplication
        : Optional[zio.aws.kafka.model.ConsumerGroupReplicationUpdate.ReadOnly]
    def currentVersion: __string
    def replicatorArn: __string
    def sourceKafkaClusterArn: __string
    def targetKafkaClusterArn: __string
    def topicReplication
        : Optional[zio.aws.kafka.model.TopicReplicationUpdate.ReadOnly]
    def getConsumerGroupReplication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ConsumerGroupReplicationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "consumerGroupReplication",
      consumerGroupReplication
    )
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
    def getReplicatorArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(replicatorArn)
    def getSourceKafkaClusterArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceKafkaClusterArn)
    def getTargetKafkaClusterArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(targetKafkaClusterArn)
    def getTopicReplication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.TopicReplicationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("topicReplication", topicReplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest
  ) extends zio.aws.kafka.model.UpdateReplicationInfoRequest.ReadOnly {
    override val consumerGroupReplication: Optional[
      zio.aws.kafka.model.ConsumerGroupReplicationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerGroupReplication())
      .map(value =>
        zio.aws.kafka.model.ConsumerGroupReplicationUpdate.wrap(value)
      )
    override val currentVersion: __string = impl.currentVersion(): __string
    override val replicatorArn: __string = impl.replicatorArn(): __string
    override val sourceKafkaClusterArn: __string =
      impl.sourceKafkaClusterArn(): __string
    override val targetKafkaClusterArn: __string =
      impl.targetKafkaClusterArn(): __string
    override val topicReplication
        : Optional[zio.aws.kafka.model.TopicReplicationUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicReplication())
        .map(value => zio.aws.kafka.model.TopicReplicationUpdate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest
  ): zio.aws.kafka.model.UpdateReplicationInfoRequest.ReadOnly = new Wrapper(
    impl
  )
}
