package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationResponse(
    arn: Optional[__string] = Optional.Absent,
    latestRevision: Optional[zio.aws.kafka.model.ConfigurationRevision] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse = {
    import UpdateConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly =
    zio.aws.kafka.model.UpdateConfigurationResponse.wrap(buildAwsValue())
}
object UpdateConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateConfigurationResponse =
      zio.aws.kafka.model.UpdateConfigurationResponse(
        arn.map(value => value),
        latestRevision.map(value => value.asEditable)
      )
    def arn: Optional[__string]
    def latestRevision
        : Optional[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
  ) extends zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val latestRevision
        : Optional[zio.aws.kafka.model.ConfigurationRevision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestRevision())
        .map(value => zio.aws.kafka.model.ConfigurationRevision.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
  ): zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
